import { StarXpandCommand } from "star-io10-web";

export class LabelSample09_For203dpiAnd300dpi_FoodPrepLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 48.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(48.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${day_of_week}\n"),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("Product\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${product}\n"),
            )
            .actionPrintText("Prepared On\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${prepared_on}\n"),
            )
            .actionPrintText("Used by\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${used_by}\n"),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(48.0),
            )
            .actionPrintText(
              "User: ${user} ",
              new StarXpandCommand.Printer.TextParameter().setWidth(16),
            )
            .actionPrintText(
              "Manager: ${manager}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(16),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "day_of_week" : "WEDNESDAY",
    "product" : "Lettuce",
    "prepared_on" : "3/24/2021",
    "used_by" : "3/25/2021",
    "user" : "A. Star",
    "manager" : "M. Star"
}`,
    );
  }
}
